/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import RuntimeTool.DebugManager;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class AlwaysOnTop {
    private static final AlwaysOnTopService mAlwaysOnTopService;
    private static Map mFrames;
    static /* synthetic */ Class class$java$awt$Window;

    private static final AlwaysOnTopService createAlwaysOnTopService() {
        if (AlwaysOnTop.hasJavaSetAlwaysOnTopMethod()) {
            return AlwaysOnTop.createJavaAlwaysOnTopService();
        }
        return AlwaysOnTop.createNativeAlwaysOnTopService();
    }

    private static final AlwaysOnTopService createJavaAlwaysOnTopService() {
        return new AlwaysOnTopService(){

            public final boolean isAvailable() {
                try {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Method method = toolkit.getClass().getMethod("isAlwaysOnTopSupported", null);
                    Object object = method.invoke((Object)toolkit, null);
                    boolean bl = false;
                    if (object instanceof Boolean) {
                        bl = (Boolean)object;
                    }
                    return bl;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public final void setAlwaysOnTop(Frame frame, boolean bl) {
                Method method = AlwaysOnTop.access$0(frame);
                if (method == null) {
                    return;
                }
                try {
                    method.invoke((Object)frame, bl);
                }
                catch (Exception exception) {
                    DebugManager.getDefault().printException("Failed to setAlwaysOnTop", exception);
                }
            }
        };
    }

    private static final AlwaysOnTopService createNativeAlwaysOnTopService() {
        try {
            System.loadLibrary("AlwaysOnTop");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            DebugManager.getDefault().printWarning("AlwaysOnTop library not loaded");
            return AlwaysOnTop.createNullAlwaysOnTopService();
        }
        return new AlwaysOnTopService(){

            public final boolean isAvailable() {
                return AlwaysOnTop.access$1();
            }

            public final void setAlwaysOnTop(Frame frame, boolean bl) {
                AlwaysOnTop.access$2(frame.getTitle(), bl);
            }
        };
    }

    private static final AlwaysOnTopService createNullAlwaysOnTopService() {
        return new AlwaysOnTopService(){

            public final boolean isAvailable() {
                return false;
            }

            public final void setAlwaysOnTop(Frame frame, boolean bl) {
            }
        };
    }

    public static void setAlwaysOnTop(Frame frame, boolean bl) {
        if (AlwaysOnTop.isAvailable() && frame != null) {
            AlwaysOnTop.debug("In AlwaysOnTop.setAlwaysOnTop(); frame = " + frame + "; onTop = " + bl);
            mAlwaysOnTopService.setAlwaysOnTop(frame, bl);
            if (bl) {
                AlwaysOnTop.debug("Adding frame to set of always-on-top frames");
                mFrames.put(frame, null);
            } else {
                AlwaysOnTop.debug("Removing frame from set of always-on-top frames");
                mFrames.remove(frame);
            }
            AlwaysOnTop.debug("Always-on-top frames: " + mFrames.keySet());
        }
    }

    public static Frame getAlwaysOnTopFrame() {
        if (!AlwaysOnTop.isAvailable()) {
            return null;
        }
        AlwaysOnTop.debug("In AlwaysOnTop.getAlwaysOnTopFrame()");
        Iterator iterator = mFrames.keySet().iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            AlwaysOnTop.debug("Possible candidate frame " + frame + "; isShowing(): " + frame.isShowing());
            if (frame == null || !frame.isShowing()) continue;
            AlwaysOnTop.debug("Returning valid always-on-top frame: " + frame);
            return frame;
        }
        AlwaysOnTop.debug("Didn't find a valid always-on-top frame");
        return null;
    }

    public static void iconizeAlwaysOnTopFrames() {
        if (!AlwaysOnTop.isAvailable()) {
            return;
        }
        AlwaysOnTop.debug("In AlwaysOnTop.iconizeAlwaysOnTopFrames()");
        Iterator iterator = mFrames.keySet().iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            AlwaysOnTop.debug("Possible candidate frame " + frame + "; isShowing(): " + frame.isShowing());
            if (frame == null || !frame.isShowing()) continue;
            frame.setState(1);
        }
        AlwaysOnTop.debug("Didn't find a valid always-on-top frame");
    }

    public static boolean isAvailable() {
        return mAlwaysOnTopService.isAvailable();
    }

    private static final boolean isSupportedOs() {
        String string = System.getProperty("os.name");
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        boolean bl = false;
        if (string2.startsWith("windows") && !string2.startsWith("windows 95") && !string2.startsWith("windows 98") && !string2.startsWith("windows nt")) {
            bl = true;
        }
        return bl;
    }

    private static final native void setAlwaysOnTopByTitle(String var0, boolean var1);

    public static Frame getParentForDialog(Frame frame, boolean bl) {
        return (Frame)AlwaysOnTop.findParent(frame, bl);
    }

    public static Window getParentForDialog(Dialog dialog, boolean bl) {
        return AlwaysOnTop.findParent(dialog, bl);
    }

    private static final Window findParent(Window window, boolean bl) {
        AlwaysOnTop.debug("In AlwaysOnTop.getParentForDialog()");
        Frame frame = AlwaysOnTop.getAlwaysOnTopFrame();
        if (!bl || frame == null) {
            AlwaysOnTop.debug("modal = " + bl + "; alwaysOnTopFrame = " + frame);
            AlwaysOnTop.debug("getParentForDialog() returning: " + window);
            return window;
        }
        AlwaysOnTop.debug("modal = " + bl + "; alwaysOnTopFrame = " + frame);
        AlwaysOnTop.debug("getParentForDialog() returning: " + frame);
        return frame;
    }

    private static final boolean debug(String string) {
        return DebugManager.getDefault().printDebug("AlwaysOnTop", string);
    }

    private static final boolean hasJavaSetAlwaysOnTopMethod() {
        boolean bl = false;
        if (AlwaysOnTop.getJavaSetAlwaysOnTopMethod(null) != null) {
            bl = true;
        }
        return bl;
    }

    private static final Method getJavaSetAlwaysOnTopMethod(Window window) {
        Class clazz;
        if (window == null) {
            clazz = class$java$awt$Window;
            if (clazz == null) {
                clazz = class$java$awt$Window = AlwaysOnTop.class$("[Ljava.awt.Window;", false);
            }
        } else {
            clazz = window.getClass();
        }
        Class clazz2 = clazz;
        try {
            return clazz2.getMethod("setAlwaysOnTop", Boolean.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Method access$0(Window window) {
        return AlwaysOnTop.getJavaSetAlwaysOnTopMethod(window);
    }

    static /* synthetic */ boolean access$1() {
        return AlwaysOnTop.isSupportedOs();
    }

    static /* synthetic */ void access$2(String string, boolean bl) {
        AlwaysOnTop.setAlwaysOnTopByTitle(string, bl);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        mFrames = Collections.synchronizedMap(new WeakHashMap());
        mAlwaysOnTopService = AlwaysOnTop.createAlwaysOnTopService();
    }

    public static interface AlwaysOnTopService {
        public void setAlwaysOnTop(Frame var1, boolean var2);

        public boolean isAvailable();
    }
}

