/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.ScreenElement;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CompositeScreen {
    public static final int INSETS_HORIZONTAL = 1;
    public static final int INSETS_VERTICAL = 2;
    public static final int INSETS_ALL = 3;
    private List mScreenElements;

    public void addScreenElement(Rectangle rectangle, Insets insets) {
        this.addScreenElement(new ScreenElement(rectangle, insets));
    }

    public void addScreenElement(ScreenElement screenElement) {
        this.mScreenElements.add(screenElement);
    }

    public int getScreenCount() {
        return this.mScreenElements.size();
    }

    public Rectangle getEnclosingBounds() {
        return this.getEnclosingBounds(0);
    }

    public Rectangle getEnclosingBounds(int n) {
        if (this.getScreenCount() == 0) {
            return new Rectangle();
        }
        Rectangle rectangle = new Rectangle(((ScreenElement)this.mScreenElements.get(0)).getBounds());
        Iterator iterator = this.mScreenElements.iterator();
        while (iterator.hasNext()) {
            rectangle.add(((ScreenElement)iterator.next()).getBounds());
        }
        this.stripInsets(rectangle, n);
        return rectangle;
    }

    public Rectangle getBounds(int n) {
        return this.getBounds(n, 0);
    }

    public Rectangle getBounds(int n, int n2) {
        Rectangle rectangle = new Rectangle(((ScreenElement)this.mScreenElements.get(n)).getBounds());
        this.stripInsets(rectangle, n2);
        return rectangle;
    }

    public int getPixelArea() {
        Rectangle rectangle = this.getEnclosingBounds();
        return rectangle.width * rectangle.height;
    }

    private final void stripInsets(Rectangle rectangle, int n) {
        if (n == 0) {
            return;
        }
        if ((n & 1) > 0) {
            this.stripHorizontalInsets(rectangle);
        }
        if ((n & 2) > 0) {
            this.stripVerticalInsets(rectangle);
        }
    }

    private final void stripHorizontalInsets(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.mScreenElements.iterator();
        while (iterator.hasNext()) {
            ScreenElement screenElement = (ScreenElement)iterator.next();
            Insets insets = screenElement.getInsets();
            if (insets == null) continue;
            n2 = Math.max(n2, insets.top);
            n = Math.max(n, insets.bottom);
        }
        rectangle.y += n2;
        rectangle.height -= n2;
        rectangle.height -= n;
    }

    private final void stripVerticalInsets(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.mScreenElements.iterator();
        while (iterator.hasNext()) {
            ScreenElement screenElement = (ScreenElement)iterator.next();
            Insets insets = screenElement.getInsets();
            if (insets == null) continue;
            n = Math.max(n, insets.left);
            n2 = Math.max(n2, insets.right);
        }
        rectangle.x += n;
        rectangle.width -= n;
        rectangle.width -= n2;
    }

    public String toString() {
        return "CompositeScreen: composed screen count = [" + this.getScreenCount() + "] bounds = [" + this.getEnclosingBounds() + "] pixel area = [" + this.getPixelArea() + ']';
    }

    private final /* synthetic */ void this() {
        this.mScreenElements = new ArrayList(10);
    }

    public CompositeScreen() {
        this.this();
    }

    public CompositeScreen(ScreenElement[] screenElementArray) {
        this.this();
        int n = 0;
        while (n < screenElementArray.length) {
            this.addScreenElement(screenElementArray[n]);
            ++n;
        }
    }
}

