/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.AlwaysOnTop;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;

    private final void init() {
        this.getLayeredPane().addContainerListener(new ContainerHandler());
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
    }

    public abstract void ok();

    public abstract void cancel();

    public EnhancedDialog(Frame frame, String string, boolean bl) {
        super(AlwaysOnTop.getParentForDialog(frame, bl), string, bl);
        this.init();
    }

    public EnhancedDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.init();
    }

    class ContainerHandler
    extends ContainerAdapter {
        public void componentAdded(ContainerEvent containerEvent) {
            this.componentAdded(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.componentRemoved(containerEvent.getChild());
        }

        private final void componentAdded(Component component) {
            component.addKeyListener(EnhancedDialog.this.keyHandler);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.addContainerListener(this);
                Component[] componentArray = container.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    this.componentAdded(componentArray[n]);
                    ++n;
                }
            }
        }

        private final void componentRemoved(Component component) {
            component.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this);
                Component[] componentArray = container.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    this.componentRemoved(componentArray[n]);
                    ++n;
                }
            }
        }

        ContainerHandler() {
        }
    }

    class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() instanceof JTextField && ((JTextField)keyEvent.getSource()).getActionListeners().length > 0) {
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                Component component = EnhancedDialog.this.getFocusOwner();
                while (component != null) {
                    if (component instanceof JComboBox) {
                        Object object;
                        JComboBox jComboBox = (JComboBox)component;
                        if (!jComboBox.isEditable() || (object = jComboBox.getEditor().getItem()) == null) break;
                        jComboBox.setSelectedItem(object);
                        break;
                    }
                    component = component.getParent();
                }
                EnhancedDialog.this.ok();
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 27) {
                EnhancedDialog.this.cancel();
                keyEvent.consume();
            }
        }

        KeyHandler() {
        }
    }

    class WindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            EnhancedDialog.this.cancel();
        }

        WindowHandler() {
        }
    }
}

