/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferenceUtilities {
    public static final String LIST_SIZE = "List Size";

    public static void setList(List list, Preferences preferences) throws BackingStoreException {
        PreferenceUtilities.removeAllChildren(preferences);
        preferences.putInt(LIST_SIZE, list.size());
        int n = 0;
        while (n < list.size()) {
            Map map = (Map)list.get(n);
            Preferences preferences2 = preferences.node("" + n);
            PreferenceUtilities.setMap(map, preferences2);
            ++n;
        }
    }

    public static void setMap(Map map, Preferences preferences) throws BackingStoreException {
        PreferenceUtilities.removeAllChildren(preferences);
        preferences.clear();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            preferences.put(string, (String)map.get(string));
        }
    }

    public static List getList(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.childrenNames();
        int n = Math.min(preferences.getInt(LIST_SIZE, stringArray.length), stringArray.length);
        ArrayList<Map> arrayList = new ArrayList<Map>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(PreferenceUtilities.createMapFromNode(preferences.node("" + n2)));
            ++n2;
        }
        return arrayList;
    }

    public static Map getMap(Preferences preferences) throws BackingStoreException {
        return PreferenceUtilities.createMapFromNode(preferences);
    }

    public static boolean isVersionKeyCompatible(Preferences preferences, int n, String string) {
        boolean bl = false;
        if (preferences.getInt(string, -1) >= n) {
            bl = true;
        }
        return bl;
    }

    private static final Map createMapFromNode(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.keys();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = preferences.get(stringArray[n], null);
            if (string != null) {
                linkedHashMap.put(stringArray[n], string);
            }
            ++n;
        }
        return linkedHashMap;
    }

    private static final void removeAllChildren(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.childrenNames();
        int n = 0;
        while (n < stringArray.length) {
            preferences.node(stringArray[n]).clear();
            ++n;
        }
    }
}

