/*
 * Decompiled with CFR 0.152.
 */
package Handler;

import Gui.GlobalState;
import Gui.ReportViewerClient;
import GuiUtilities.Util.GuiUtilities;
import Preferences.ClientPreferenceProvider;
import java.awt.Dimension;

public class ExitHandler {
    private ReportViewerClient mClient;

    public void exitNow() {
        this.saveUserPreferences(this.mClient);
        if (this.mClient != null) {
            this.mClient.dispose();
        }
        GlobalState.trace("Closing Report Viewer");
        System.exit(0);
    }

    private final void saveUserPreferences(ReportViewerClient reportViewerClient) {
        GlobalState.trace("Saving user preferences before exiting...");
        if (this.mClient != null) {
            double d;
            Dimension dimension = GuiUtilities.getScreenSize();
            double d2 = dimension.getWidth();
            if (d2 <= 0.0) {
                d2 = 1.0;
            }
            if ((d = dimension.getHeight()) <= 0.0) {
                d = 1.0;
            }
            GlobalState.getPreferenceProvider().setMainWindowX((double)reportViewerClient.getX() / d2);
            GlobalState.getPreferenceProvider().setMainWindowY((double)reportViewerClient.getY() / d);
            GlobalState.getPreferenceProvider().setMainWindowWidth((double)reportViewerClient.getWidth() / d2);
            GlobalState.getPreferenceProvider().setMainWindowHeight((double)reportViewerClient.getHeight() / d);
        }
        ((ClientPreferenceProvider)GlobalState.getPreferenceProvider()).flush();
    }

    public ExitHandler(ReportViewerClient reportViewerClient) {
        this.mClient = reportViewerClient;
    }
}

