/*
 * Decompiled with CFR 0.152.
 */
package Preferences;

import GuiUtilities.Util.PreferenceUtilities;
import Preferences.PreferenceNodeManager;
import ReportViewerLibrary.Preferences.ReportViewerPreferenceProvider;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClientPreferenceProvider
implements ReportViewerPreferenceProvider {
    private PreferenceNodeManager mGuiNode;
    private PreferenceNodeManager mOrdersTableNode;

    private final void initializeNodes(String string) {
        if (ClientPreferenceProvider.isVersionKeyCompatible(string)) {
            String string2 = "/Intelerad Medical Systems/Clinical Viewer/Users";
            this.mGuiNode = new PreferenceNodeManager(string, string2, "/Report Viewer/Gui");
            this.mOrdersTableNode = new PreferenceNodeManager(string, string2, "/Report Viewer/Gui/OrdersTable");
        } else {
            String string3 = "/Intelerad Medical Systems/Report Viewer/Users";
            this.mGuiNode = new PreferenceNodeManager(string, string3, "/Gui");
            this.mOrdersTableNode = new PreferenceNodeManager(string, string3, "/Gui/OrdersTable");
        }
    }

    public static boolean isVersionKeyCompatible(String string) {
        String string2 = "/Intelerad Medical Systems/Clinical Viewer/Users/" + string + "/Report Viewer";
        Preferences preferences = Preferences.userRoot().node(string2);
        boolean bl = false;
        if (preferences.getInt("Version", -1) >= 3) {
            bl = true;
        }
        return bl;
    }

    public void flush() {
        this.mGuiNode.flush();
    }

    private static final double limitMainWindowPosition(double d) {
        double d2 = d;
        return d2;
    }

    private static final double limitMainWindowSize(double d) {
        double d2 = d;
        return d2;
    }

    public double getMainWindowX() {
        return ClientPreferenceProvider.limitMainWindowPosition(this.mGuiNode.getDouble("Main Window X", 0.1));
    }

    public void setMainWindowX(double d) {
        this.mGuiNode.putDouble("Main Window X", ClientPreferenceProvider.limitMainWindowPosition(d), this.getMainWindowX());
    }

    public double getMainWindowY() {
        return ClientPreferenceProvider.limitMainWindowPosition(this.mGuiNode.getDouble("Main Window Y", 0.1));
    }

    public void setMainWindowY(double d) {
        this.mGuiNode.putDouble("Main Window Y", ClientPreferenceProvider.limitMainWindowPosition(d), this.getMainWindowY());
    }

    public double getMainWindowWidth() {
        return ClientPreferenceProvider.limitMainWindowSize(this.mGuiNode.getDouble("Main Window Width", 0.5));
    }

    public void setMainWindowWidth(double d) {
        this.mGuiNode.putDouble("Main Window Width", ClientPreferenceProvider.limitMainWindowSize(d), this.getMainWindowWidth());
    }

    public double getMainWindowHeight() {
        return ClientPreferenceProvider.limitMainWindowSize(this.mGuiNode.getDouble("Main Window Height", 0.7));
    }

    public void setMainWindowHeight(double d) {
        this.mGuiNode.putDouble("Main Window Height", ClientPreferenceProvider.limitMainWindowSize(d), this.getMainWindowHeight());
    }

    public boolean isAlwaysOnTop() {
        return this.mGuiNode.getBoolean("Always On Top", false);
    }

    public void setAlwaysOnTop(boolean bl) {
        this.mGuiNode.putBoolean("Always On Top", bl, this.isAlwaysOnTop());
    }

    public boolean isSplitView() {
        return this.mGuiNode.getBoolean("Split View", false);
    }

    public void setSplitView(boolean bl) {
        this.mGuiNode.putBoolean("Split View", bl, this.isSplitView());
    }

    public double getReportViewerDividerLocation() {
        double d = this.mGuiNode.getDouble("Divider Location", 0.5);
        if (d < 0.0 || d > 1.0) {
            return 0.5;
        }
        return d;
    }

    public void setReportViewerDividerLocation(double d) {
        this.mGuiNode.putDouble("Divider Location", d, this.getReportViewerDividerLocation());
    }

    public void setListOfOrdersColumnPreferences(List list) throws BackingStoreException {
        Preferences preferences = this.mOrdersTableNode.getUserNode();
        PreferenceUtilities.setList(list, preferences);
    }

    public List getListOfOrdersColumnPreferences() throws BackingStoreException {
        Preferences preferences = this.mOrdersTableNode.getUserNode();
        return PreferenceUtilities.getList(preferences);
    }

    private final /* synthetic */ void this() {
        this.mGuiNode = null;
        this.mOrdersTableNode = null;
    }

    public ClientPreferenceProvider(String string) {
        this.this();
        this.initializeNodes(string);
        this.flush();
    }
}

