/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.Enum;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExportConfiguration {
    public static final float DEFAULT_LEFT_MARGIN = 0.5f;
    public static final float DEFAULT_RIGHT_MARGIN = 0.25f;
    public static final float DEFAULT_TOP_MARGIN = 0.5f;
    public static final float DEFAULT_BOTTOM_MARGIN = 0.5f;
    public static final float DEFAULT_FOOTER_MARGIN = 0.25f;
    public static final boolean DEFAULT_INCLUDE_LOGO = true;
    public static final boolean DEFAULT_INCLUDE_HEADER = true;
    public static final boolean DEFAULT_INCLUDE_LINE_SEPARATOR = false;
    public static final boolean DEFAULT_REPEAT_HEADER = true;
    public static final String DEFAULT_REPORT_TITLE = "";
    public static final HeaderFieldType DEFAULT_PROMINENT_FIELD = HeaderFieldType.STUDY_DESCRIPTION;
    public static final HeaderFieldType[] DEFAULT_COLUMN_1_FIELDS = new HeaderFieldType[]{HeaderFieldType.ACCESSION, HeaderFieldType.MODALITY, HeaderFieldType.REQUESTED_PROCEDURE_ID, HeaderFieldType.PATIENT_NAME, HeaderFieldType.PATIENT_DATE_OF_BIRTH, HeaderFieldType.REFERING_PHYSICIAN, HeaderFieldType.STUDY_DATE};
    public static final HeaderFieldType[] DEFAULT_COLUMN_2_FIELDS = new HeaderFieldType[0];
    private float mLeftMargin;
    private float mRightMargin;
    private float mTopMargin;
    private float mBottomMargin;
    private float mFooterMargin;
    private boolean mIncludeLogo;
    private boolean mIncludeHeader;
    private boolean mIncludeLineSeparator;
    private boolean mRepeatHeader;
    private Map mColumnToHeaderFieldListMap;
    private HeaderFieldType mProminentHeaderField;
    private String mReportTitle;
    private Map mHeaderFieldToLabelMap;

    public float getBottomMargin() {
        return this.mBottomMargin;
    }

    public void setBottomMargin(float f) {
        this.mBottomMargin = f;
    }

    public float getFooterMargin() {
        return this.mFooterMargin;
    }

    public void setFooterMargin(float f) {
        this.mFooterMargin = f;
    }

    public float getLeftMargin() {
        return this.mLeftMargin;
    }

    public void setLeftMargin(float f) {
        this.mLeftMargin = f;
    }

    public float getRightMargin() {
        return this.mRightMargin;
    }

    public void setRightMargin(float f) {
        this.mRightMargin = f;
    }

    public float getTopMargin() {
        return this.mTopMargin;
    }

    public void setTopMargin(float f) {
        this.mTopMargin = f;
    }

    public boolean includeLogo() {
        return this.mIncludeLogo;
    }

    public void setIncludeLogo(boolean bl) {
        this.mIncludeLogo = bl;
    }

    public String getReportTitle() {
        return this.mReportTitle;
    }

    public void setReportTitle(String string) {
        this.mReportTitle = string;
    }

    public boolean includeHeader() {
        return this.mIncludeHeader;
    }

    public void setIncludeHeader(boolean bl) {
        this.mIncludeHeader = bl;
    }

    public boolean repeatHeader() {
        return this.mRepeatHeader;
    }

    public void setRepeatHeader(boolean bl) {
        this.mRepeatHeader = bl;
    }

    public void setIncludeLineSeparator(boolean bl) {
        this.mIncludeLineSeparator = bl;
    }

    public boolean includeLineSeparator() {
        return this.mIncludeLineSeparator;
    }

    public HeaderFieldType getProminentHeaderField() {
        return this.mProminentHeaderField;
    }

    public void setProminentHeaderField(HeaderFieldType headerFieldType) {
        this.mProminentHeaderField = headerFieldType;
    }

    public void setHeaderFields(List list, HeaderColumnType headerColumnType) {
        this.mColumnToHeaderFieldListMap.put(headerColumnType, new ArrayList(list));
    }

    public List getHeaderFields(HeaderColumnType headerColumnType) {
        return Collections.unmodifiableList((List)this.mColumnToHeaderFieldListMap.get((Object)headerColumnType));
    }

    public void setHeaderFieldLabels(Map map) {
        this.mHeaderFieldToLabelMap.putAll(map);
    }

    public Map getHeaderFieldLabels() {
        return Collections.unmodifiableMap(this.mHeaderFieldToLabelMap);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ReportViewerExport configuration: margins (left, right, top bottom, footer) =(").append(this.mLeftMargin).append(",").append(this.mRightMargin).append(",").append(this.mTopMargin).append(",").append(this.mBottomMargin).append(",").append(this.mFooterMargin).append("), ").append("includes logo:").append(this.mIncludeLogo).append(", ").append("includes header:").append(this.mIncludeHeader).append(", ").append("repeat header: ").append(this.mRepeatHeader).append(", ").append("Line separator: ").append(this.mIncludeLineSeparator).append(", ");
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.mColumnToHeaderFieldListMap = new HashMap();
        this.mHeaderFieldToLabelMap = new HashMap();
    }

    public ExportConfiguration() {
        this.this();
        this.mLeftMargin = 0.5f;
        this.mRightMargin = 0.25f;
        this.mTopMargin = 0.5f;
        this.mBottomMargin = 0.5f;
        this.mFooterMargin = 0.25f;
        this.mIncludeLogo = true;
        this.mIncludeHeader = true;
        this.mRepeatHeader = true;
        this.mIncludeLineSeparator = false;
        this.mProminentHeaderField = DEFAULT_PROMINENT_FIELD;
        this.mColumnToHeaderFieldListMap.put(HeaderColumnType.FIRST_COLUMN, Arrays.asList(DEFAULT_COLUMN_1_FIELDS));
        this.mColumnToHeaderFieldListMap.put(HeaderColumnType.SECOND_COLUMN, Arrays.asList(DEFAULT_COLUMN_2_FIELDS));
    }

    public static class HeaderColumnType
    extends Enum {
        public static final HeaderColumnType FIRST_COLUMN = new HeaderColumnType("0");
        public static final HeaderColumnType SECOND_COLUMN = new HeaderColumnType("1");
        private static List mKnownHeaderColumnTypes;
        static /* synthetic */ Class class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType;

        public static HeaderColumnType getInstance(String string) throws InvalidHeaderColumnTypeException {
            HeaderColumnType headerColumnType;
            Class clazz = class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType;
            if (clazz == null) {
                clazz = class$ReportViewerLibrary$Export$ExportConfiguration$HeaderColumnType = HeaderColumnType.class$("[LReportViewerLibrary.Export.ExportConfiguration$HeaderColumnType;", false);
            }
            if (!mKnownHeaderColumnTypes.contains((Object)(headerColumnType = (HeaderColumnType)HeaderColumnType.getEnum((Class)clazz, (String)string)))) {
                throw new InvalidHeaderColumnTypeException("Invalid [" + string + "] column ");
            }
            return headerColumnType;
        }

        static /* synthetic */ Class class$(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        private HeaderColumnType(String string) {
            super(string);
            if (mKnownHeaderColumnTypes == null) {
                mKnownHeaderColumnTypes = new ArrayList();
            }
            mKnownHeaderColumnTypes.add(this);
        }
    }

    public static class HeaderFieldType
    extends Enum {
        private static List mKnownHeaderFieldTypes;
        public static final HeaderFieldType PATIENT_NAME;
        public static final HeaderFieldType PATIENT_DATE_OF_BIRTH;
        public static final HeaderFieldType PATIENT_ID;
        public static final HeaderFieldType REFERING_PHYSICIAN;
        public static final HeaderFieldType ORGANIZATION;
        public static final HeaderFieldType STUDY_DATE;
        public static final HeaderFieldType ACCESSION;
        public static final HeaderFieldType REQUESTED_PROCEDURE_ID;
        public static final HeaderFieldType STUDY_DESCRIPTION;
        public static final HeaderFieldType MODALITY;
        public static final HeaderFieldType REPORTING_MD;
        public static final HeaderFieldType DICTATED_STUDY_DATE;
        static /* synthetic */ Class class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType;

        public static HeaderFieldType getInstance(String string) throws InvalidHeaderFieldTypeException {
            HeaderFieldType headerFieldType;
            Class clazz = class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType;
            if (clazz == null) {
                clazz = class$ReportViewerLibrary$Export$ExportConfiguration$HeaderFieldType = HeaderFieldType.class$("[LReportViewerLibrary.Export.ExportConfiguration$HeaderFieldType;", false);
            }
            if (!mKnownHeaderFieldTypes.contains((Object)(headerFieldType = (HeaderFieldType)HeaderFieldType.getEnum((Class)clazz, (String)string)))) {
                throw new InvalidHeaderFieldTypeException("Unknown [" + string + "] header field type");
            }
            return headerFieldType;
        }

        static /* synthetic */ Class class$(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        private HeaderFieldType(String string) {
            super(string);
            if (mKnownHeaderFieldTypes == null) {
                mKnownHeaderFieldTypes = new ArrayList();
            }
            mKnownHeaderFieldTypes.add(this);
        }

        static {
            PATIENT_NAME = new HeaderFieldType("Patient");
            PATIENT_DATE_OF_BIRTH = new HeaderFieldType("PatientDOB");
            PATIENT_ID = new HeaderFieldType("PatientID");
            REFERING_PHYSICIAN = new HeaderFieldType("ReferingPhysician");
            ORGANIZATION = new HeaderFieldType("Organization");
            STUDY_DATE = new HeaderFieldType("StudyDate");
            ACCESSION = new HeaderFieldType("Accession");
            REQUESTED_PROCEDURE_ID = new HeaderFieldType("RequestedProcedureID");
            STUDY_DESCRIPTION = new HeaderFieldType("StudyDescription");
            MODALITY = new HeaderFieldType("Modality");
            REPORTING_MD = new HeaderFieldType("ReportingMD");
            DICTATED_STUDY_DATE = new HeaderFieldType("DictatedStudyDate");
        }
    }

    public static class InvalidHeaderFieldTypeException
    extends Exception {
        public InvalidHeaderFieldTypeException(String string) {
            super(string);
        }
    }

    public static class InvalidHeaderColumnTypeException
    extends Exception {
        public InvalidHeaderColumnTypeException(String string) {
            super(string);
        }
    }
}

