/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.HeaderField;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import StringUtilities.StringCheck;
import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HeaderRenderer {
    private static final int TWO_COLUMNS_HEADER_FONT_SIZE = 9;
    private static final Font TWO_COLUMN_HEADER_LABEL_FONT = FontFactory.getFont((String)"unknown", (float)9.0f, (int)1);
    private static final Font TWO_COLUMN_HEADER_VALUE_FONT = FontFactory.getFont((String)"unknown", (float)9.0f, (int)0);
    private static final int ONE_COLUMN_HEADER_FONT_SIZE = 11;
    private static final Font ONE_COLUMN_HEADER_LABEL_FONT = FontFactory.getFont((String)"unknown", (float)11.0f, (int)1);
    private static final Font ONE_COLUMN_HEADER_VALUE_FONT = FontFactory.getFont((String)"unknown", (float)11.0f, (int)0);
    private static final int PROMINENT_HEADER_FONT_SIZE = 14;
    private static final Font PROMINENT_HEADER_VALUE_FONT = FontFactory.getFont((String)"unknown", (float)14.0f, (int)1);
    private static final int TITLE_FONT_SIZE = 16;
    private static final Font TITLE_HEADER_LABEL_FONT = FontFactory.getFont((String)"unknown", (float)16.0f, (int)2);
    private final ExportConfiguration mExportConfiguration;
    private final Map mHeaderFields;
    private int mRowCount;

    private final void initConfiguration() {
        Object object;
        Map map = this.mExportConfiguration.getHeaderFieldLabels();
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ExportConfiguration.HeaderFieldType headerFieldType = (ExportConfiguration.HeaderFieldType)((Object)object.getKey());
            String string = (String)object.getValue();
            ((HeaderField)this.mHeaderFields.get((Object)headerFieldType)).setLabel(string);
        }
        object2 = this.mExportConfiguration.getHeaderFields(ExportConfiguration.HeaderColumnType.FIRST_COLUMN);
        object = this.mExportConfiguration.getHeaderFields(ExportConfiguration.HeaderColumnType.SECOND_COLUMN);
        this.mRowCount = object2.size() > object.size() ? object2.size() : object.size();
    }

    public PdfPTable getFields(OrderHeader orderHeader, Patient patient) {
        List list = this.getHeaderFields(ExportConfiguration.HeaderColumnType.FIRST_COLUMN);
        List list2 = this.getHeaderFields(ExportConfiguration.HeaderColumnType.SECOND_COLUMN);
        int n = 0;
        if (list2.size() == 0) {
            n = 1;
        }
        boolean bl = 1 - n;
        float[] fArray = this.getColumnWidths(bl);
        PdfPTable pdfPTable = new PdfPTable(fArray);
        pdfPTable.setSpacingBefore(12.0f);
        pdfPTable.addCell(this.createProminentFieldCell(orderHeader, patient, fArray.length));
        int n2 = 0;
        while (n2 < this.mRowCount) {
            PdfPCell pdfPCell = new PdfPCell(this.createFieldCell(n2, list, orderHeader, patient, fArray.length));
            pdfPCell.setLeading(2.0f, 1.0f);
            pdfPCell.setBorder(0);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setVerticalAlignment(1);
            pdfPTable.addCell(pdfPCell);
            if (bl) {
                pdfPCell = new PdfPCell(this.createFieldCell(n2, list2, orderHeader, patient, fArray.length));
                pdfPCell.setLeading(2.0f, 1.0f);
                pdfPCell.setBorder(0);
                pdfPCell.setPadding(0.0f);
                pdfPCell.setPaddingRight(2.0f);
                pdfPCell.setVerticalAlignment(1);
                pdfPTable.addCell(pdfPCell);
            }
            ++n2;
        }
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.setSpacingAfter(8.0f);
        pdfPTable.setWidthPercentage(100.0f);
        return pdfPTable;
    }

    public PdfPTable getLogoAndTitle(Image image) {
        if (!this.hasTitle() && image == null) {
            return new PdfPTable(1);
        }
        int n = this.hasTitle() && image != null ? 2 : 1;
        PdfPTable pdfPTable = new PdfPTable(n);
        if (this.hasTitle()) {
            pdfPTable.addCell(this.createTitleCell());
        }
        if (image != null) {
            pdfPTable.addCell(this.createLogoCell(image));
        }
        pdfPTable.setSpacingAfter((float)5);
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.setWidthPercentage(100.0f);
        return pdfPTable;
    }

    private final PdfPCell createLogoCell(Image image) {
        PdfPCell pdfPCell = new PdfPCell(image);
        pdfPCell.setHorizontalAlignment(2);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingRight(30.0f);
        return pdfPCell;
    }

    private final PdfPCell createTitleCell() {
        PdfPCell pdfPCell = HeaderRenderer.createPdfCell(this.mExportConfiguration.getReportTitle(), TITLE_HEADER_LABEL_FONT);
        pdfPCell.setHorizontalAlignment(0);
        pdfPCell.setVerticalAlignment(5);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingLeft(0.0f);
        return pdfPCell;
    }

    private final boolean hasTitle() {
        return StringCheck.isStringBlank(this.mExportConfiguration.getReportTitle()) ^ true;
    }

    private final float[] getColumnWidths(boolean bl) {
        float[] fArray = bl ? new float[]{0.5f, 0.5f} : new float[]{1.0f};
        return fArray;
    }

    private final List getHeaderFields(ExportConfiguration.HeaderColumnType headerColumnType) {
        ArrayList<HeaderField> arrayList = new ArrayList<HeaderField>();
        List list = this.mExportConfiguration.getHeaderFields(headerColumnType);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExportConfiguration.HeaderFieldType headerFieldType = (ExportConfiguration.HeaderFieldType)((Object)iterator.next());
            arrayList.add(this.getHeaderField(headerFieldType));
        }
        return arrayList;
    }

    private final HeaderField getHeaderField(ExportConfiguration.HeaderFieldType headerFieldType) {
        return (HeaderField)this.mHeaderFields.get((Object)headerFieldType);
    }

    private final PdfPTable createFieldCell(int n, List list, OrderHeader orderHeader, Patient patient, int n2) {
        float[] fArray = new float[]{0.4f, 0.05f, 0.6f};
        if (n2 == 1) {
            fArray[0] = 0.2f;
            fArray[1] = 0.03f;
            fArray[2] = 0.77f;
        }
        PdfPTable pdfPTable = new PdfPTable(fArray);
        if (n >= list.size()) {
            return pdfPTable;
        }
        HeaderField headerField = (HeaderField)list.get(n);
        pdfPTable.addCell(HeaderRenderer.createPdfCell(headerField.getLabel(), HeaderRenderer.getLabelFont(n2)));
        float[] fArray2 = new float[4];
        fArray2[0] = 3;
        fArray2[2] = 3;
        pdfPTable.addCell(HeaderRenderer.createPdfCell(":", HeaderRenderer.getLabelFont(n2), fArray2));
        pdfPTable.addCell(HeaderRenderer.createPdfCell(headerField.getValue(orderHeader, patient), HeaderRenderer.getValueFont(n2)));
        return pdfPTable;
    }

    private final PdfPCell createProminentFieldCell(OrderHeader orderHeader, Patient patient, int n) {
        PdfPTable pdfPTable = new PdfPTable(1);
        if (this.mExportConfiguration.getProminentHeaderField() != null) {
            pdfPTable.addCell(HeaderRenderer.createPdfCell(this.getHeaderField(this.mExportConfiguration.getProminentHeaderField()).getValue(orderHeader, patient), PROMINENT_HEADER_VALUE_FONT));
        }
        PdfPCell pdfPCell = new PdfPCell(pdfPTable);
        pdfPCell.setColspan(n);
        pdfPCell.setBorder(0);
        pdfPCell.setPaddingBottom(10.0f);
        return pdfPCell;
    }

    private static final PdfPCell createPdfCell(String string, Font font) {
        return HeaderRenderer.createPdfCell(string, font, new float[4]);
    }

    private static final PdfPCell createPdfCell(String string, Font font, float[] fArray) {
        Phrase phrase = new Phrase();
        phrase.add((Object)new Chunk(string, font));
        PdfPCell pdfPCell = new PdfPCell(phrase);
        pdfPCell.setLeading(2.0f, 1.0f);
        pdfPCell.setPaddingLeft(fArray[0]);
        pdfPCell.setPaddingTop(fArray[1]);
        pdfPCell.setPaddingRight(fArray[2]);
        pdfPCell.setPaddingBottom(fArray[3]);
        pdfPCell.setVerticalAlignment(1);
        pdfPCell.setBorder(0);
        return pdfPCell;
    }

    private static final Font getLabelFont(int n) {
        if (n == 1) {
            return ONE_COLUMN_HEADER_LABEL_FONT;
        }
        return TWO_COLUMN_HEADER_LABEL_FONT;
    }

    private static final Font getValueFont(int n) {
        if (n == 1) {
            return ONE_COLUMN_HEADER_VALUE_FONT;
        }
        return TWO_COLUMN_HEADER_VALUE_FONT;
    }

    private final /* synthetic */ void this() {
        this.mHeaderFields = HeaderField.getAllHeaderFields();
    }

    public HeaderRenderer(ExportConfiguration exportConfiguration) {
        this.this();
        this.mExportConfiguration = exportConfiguration;
        this.initConfiguration();
    }
}

