/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import FileUtilities.FileNaming;
import GuiUtilities.Dialog.MultiMonitorOptionDialog;
import GuiUtilities.Icon.IconCache;
import GuiUtilities.Layouts.ParagraphLayout;
import GuiUtilities.Util.EnhancedDialog;
import GuiUtilities.Util.EnhancedJFileChooser;
import GuiUtilities.Util.GuiUtilities;
import GuiUtilities.Worker.Worker;
import GuiUtilities.Worker.WorkerController;
import GuiUtilities.Worker.WorkerControllerUtilities;
import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.ReportExporter;
import ReportViewerLibrary.Export.ReportImageProvider;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerXml.Patient;
import RuntimeTool.DebugManager;
import com.intelerad.lib.process.UrlLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReportExportDialog
extends EnhancedDialog
implements ActionListener {
    private static File mInitialDirectory = new File(System.getProperty("user.home"));
    private static final ImageIcon mPdfIcon = new IconCache().getImageIcon("/ReportViewerLibrary/Gui/Icons/pdf-format.png");
    private final ReportViewer mReportViewer;
    private final ReportImageProvider mReportImageProvider;
    private final ExportConfiguration mExportConfiguration;
    private File mTempDirectory;
    private File mExportedReportFile;
    private JCheckBox mIncludeAllReportsCheckBox;
    private JCheckBox mIncludeKeyImagesCheckBox;
    private JCheckBox mIncludeImpressionsCheckBox;
    private JCheckBox mIncludeHistoryCheckBox;
    private JButton mExportButton;
    private JButton mViewButton;
    private JButton mCancelButton;

    private final void init(Window window, File file) {
        this.initTempDirectory(file);
        this.guiInit();
        this.pack();
        this.setSize(500, (int)this.getPreferredSize().getHeight());
        this.setResizable(true);
        GuiUtilities.centerWindowOnParent(window, this);
    }

    private final void initTempDirectory(File file) {
        if (file != null && file.isDirectory() && file.canWrite()) {
            this.mTempDirectory = file;
        } else {
            String string = System.getProperty("java.io.tmpdir");
            String string2 = "Could not use given temporary directory: " + (file == null ? "null" : file.getAbsolutePath()) + ". Using default temporary directory instead: " + string;
            DebugManager.getDefault().printWarning(string2);
            this.mTempDirectory = new File(string);
        }
    }

    private final void guiInit() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.createInfoPane(jPanel);
        this.createOptionPane(jPanel);
        this.createControlButton(jPanel);
        this.setContentPane(jPanel);
    }

    private final void createInfoPane(JPanel jPanel) {
        Patient patient = this.mReportViewer.getPatient();
        ParagraphLayout paragraphLayout = new ParagraphLayout();
        JPanel jPanel2 = new JPanel(paragraphLayout);
        jPanel2.setBorder(GuiUtilities.getTitledBorder(" Study Information ", Color.ORANGE, Color.BLACK, 3));
        JLabel jLabel = new JLabel("Patient Name :");
        JLabel jLabel2 = new JLabel("Patient ID :");
        JLabel jLabel3 = new JLabel("Accession Number :");
        JLabel jLabel4 = new JLabel("Requested Procedure ID :");
        JLabel jLabel5 = new JLabel("Modality :");
        JLabel jLabel6 = new JLabel("Study Description :");
        JLabel jLabel7 = new JLabel(patient.getName());
        JLabel jLabel8 = new JLabel(patient.getId());
        JLabel jLabel9 = new JLabel(this.mReportViewer.getReportsPane().getCurrentOrder().getAccession());
        JLabel jLabel10 = new JLabel(this.mReportViewer.getReportsPane().getCurrentOrder().getRequestedProcedureId());
        JLabel jLabel11 = new JLabel(this.mReportViewer.getReportsPane().getCurrentOrderHeader().getModality());
        JLabel jLabel12 = new JLabel(this.mReportViewer.getReportsPane().getCurrentOrderHeader().getDescription());
        jLabel7.setForeground(Color.BLUE);
        jLabel8.setForeground(Color.BLUE);
        jLabel9.setForeground(Color.BLUE);
        jLabel10.setForeground(Color.BLUE);
        jLabel11.setForeground(Color.BLUE);
        jLabel12.setForeground(Color.BLUE);
        jPanel2.add(jLabel);
        jPanel2.add(jLabel7);
        jPanel2.add((Component)jLabel2, ParagraphLayout.NEW_PARAGRAPH);
        jPanel2.add(jLabel8);
        jPanel2.add((Component)jLabel3, ParagraphLayout.NEW_PARAGRAPH);
        jPanel2.add(jLabel9);
        if (this.mReportViewer.isIheMode()) {
            jPanel2.add((Component)jLabel4, ParagraphLayout.NEW_PARAGRAPH);
            jPanel2.add(jLabel10);
        }
        jPanel2.add((Component)jLabel5, ParagraphLayout.NEW_PARAGRAPH);
        jPanel2.add(jLabel11);
        jPanel2.add((Component)jLabel6, ParagraphLayout.NEW_PARAGRAPH);
        jPanel2.add(jLabel12);
        jPanel.add("North", jPanel2);
    }

    private final void createOptionPane(JPanel jPanel) {
        this.mIncludeAllReportsCheckBox = new JCheckBox("Include all reports", false);
        this.mIncludeAllReportsCheckBox.addActionListener(this);
        this.mIncludeKeyImagesCheckBox = new JCheckBox("Include Key Images ", true);
        this.mIncludeImpressionsCheckBox = new JCheckBox("Include Impressions");
        this.mIncludeHistoryCheckBox = new JCheckBox("Include Clinical History");
        if (this.mReportViewer.getOrderHeaderMap().size() <= 1) {
            this.mIncludeAllReportsCheckBox.setEnabled(false);
        }
        this.updateKeyImageCheckBox();
        Box box = new Box(1);
        box.setBorder(GuiUtilities.getTitledBorder(" Export Options ", 3));
        box.add(this.mIncludeKeyImagesCheckBox);
        box.add(Box.createGlue());
        box.add(this.mIncludeImpressionsCheckBox);
        box.add(Box.createGlue());
        box.add(this.mIncludeHistoryCheckBox);
        box.add(Box.createGlue());
        box.add(this.mIncludeAllReportsCheckBox);
        box.add(Box.createGlue());
        jPanel.add("Center", box);
    }

    private final void createControlButton(JPanel jPanel) {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(8, 8, 8, 8));
        box.add(Box.createGlue());
        this.mExportButton = new JButton("Save");
        this.mExportButton.addActionListener(this);
        this.mViewButton = new JButton("View");
        this.mViewButton.addActionListener(this);
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(this);
        box.add(this.mExportButton);
        box.add(Box.createGlue());
        box.add(this.mViewButton);
        box.add(Box.createGlue());
        box.add(this.mCancelButton);
        box.add(Box.createGlue());
        jPanel.add("South", box);
    }

    public void ok() {
        this.export();
    }

    public void cancel() {
        this.dispose();
    }

    private final void launchPdf(File file) {
        try {
            UrlLauncher urlLauncher = new UrlLauncher(file.toURL(), "reportViewer", true);
            urlLauncher.launch();
        }
        catch (MalformedURLException malformedURLException) {
            DebugManager.getDefault().printException("Could not create URL to temporary file: " + file, malformedURLException);
            this.showErrorMessage("Could not launch the PDF viewer.\nPlease contact your PACS administrator");
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Could not launch PDF viewer", iOException);
            this.showErrorMessage("Could not launch the PDF viewer.\nPlease make sure that Adobe Reader\nor another PDF viewer is properly configured.");
        }
    }

    private final void setExportedReportFile(File file) {
        this.dispose();
        this.updateInitialDirectory(file);
        this.mExportedReportFile = file;
    }

    private final void updateInitialDirectory(File file) {
        if (file != null && (mInitialDirectory = file.getParentFile()) == null) {
            mInitialDirectory = new File(System.getProperty("user.home"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mExportButton) {
            this.ok();
        }
        if (actionEvent.getSource() == this.mViewButton) {
            this.view();
        } else if (actionEvent.getSource() == this.mCancelButton) {
            this.cancel();
        } else if (actionEvent.getSource() == this.mIncludeAllReportsCheckBox) {
            this.updateKeyImageCheckBox();
        }
    }

    public File getExportedReportFile() {
        return this.mExportedReportFile;
    }

    private final void updateKeyImageCheckBox() {
        boolean bl = this.mReportViewer.getAccession().equals(this.mReportViewer.getReportsPane().getCurrentOrderHeader().getAccession());
        if (this.hasImages() && (this.mIncludeAllReportsCheckBox.isSelected() || bl)) {
            this.mIncludeKeyImagesCheckBox.setEnabled(true);
        } else {
            this.mIncludeKeyImagesCheckBox.setSelected(false);
            this.mIncludeKeyImagesCheckBox.setEnabled(false);
        }
    }

    private final void view() {
        try {
            File file = File.createTempFile("Report", ".pdf", this.mTempDirectory);
            file.deleteOnExit();
            ReportExportWorker reportExportWorker = new ReportExportWorker(file, true);
            WorkerController workerController = WorkerControllerUtilities.createCancellableController(reportExportWorker, this, mPdfIcon, "Exporting PDF Report...");
            workerController.start();
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Could not create a temporary PDF file", iOException);
            this.showErrorMessage("Could not open the PDF file.\nA temporary file could not be created.");
        }
    }

    private final void export() {
        File file = this.getReportFile(this.getCurrentExamId());
        if (file == null) {
            return;
        }
        ReportExportWorker reportExportWorker = new ReportExportWorker(file, false);
        WorkerController workerController = WorkerControllerUtilities.createCancellableController(reportExportWorker, this, mPdfIcon, "Exporting PDF Report...");
        workerController.start();
    }

    private final File getReportFile(String string) {
        File file;
        int n;
        EnhancedJFileChooser enhancedJFileChooser = new EnhancedJFileChooser(mInitialDirectory);
        enhancedJFileChooser.setDialogTitle("Save as");
        enhancedJFileChooser.setFileFilter(new PdfFileFilter());
        enhancedJFileChooser.setSelectedFile(new File(this.defaultReportFileName(string)));
        do {
            int n2 = enhancedJFileChooser.showDialog(this, "Save");
            GuiUtilities.centerWindow(SwingUtilities.getWindowAncestor(enhancedJFileChooser));
            if (n2 != 0) {
                return null;
            }
            file = enhancedJFileChooser.getSelectedFile();
            String string2 = file.getAbsolutePath();
            if (!string2.toLowerCase().endsWith(".pdf")) {
                file = new File(string2 + ".pdf");
                enhancedJFileChooser.setSelectedFile(file);
            }
            if (!file.exists()) break;
            n = MultiMonitorOptionDialog.showConfirmDialog(this, "File " + file + " already exist. Overwrite?", "Overwrite file?", 1);
            if (n != 2) continue;
            return null;
        } while (n == 1);
        return file;
    }

    private final ReportExporter createExporter() {
        Map map = this.mReportViewer.getOrderMap();
        Map map2 = this.mReportViewer.getOrderHeaderMap();
        ReportExporter reportExporter = new ReportExporter(this.mReportViewer.getPatient(), map, map2, this.mReportImageProvider, this.getCurrentExamId(), this.mReportViewer.isIheMode(), this.mExportConfiguration);
        reportExporter.setPrintAll(this.mIncludeAllReportsCheckBox.isSelected());
        reportExporter.setIncludeKeyImages(this.mIncludeKeyImagesCheckBox.isSelected());
        reportExporter.setIncludeImpressions(this.mIncludeImpressionsCheckBox.isSelected());
        reportExporter.setIncludeHistory(this.mIncludeHistoryCheckBox.isSelected());
        return reportExporter;
    }

    private final boolean hasImages() {
        boolean bl = false;
        if (this.mReportImageProvider.getKeyImageCount(this.getCurrentAccessionNumber()) > 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (this.mReportViewer.getOrderMap().containsKey(this.mReportViewer.getExamId().getPacsKey()) && this.mReportImageProvider.getKeyImageCount(this.mReportViewer.getAccession()) > 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (bl2 || this.mIncludeAllReportsCheckBox.isSelected() && bl4) {
            bl5 = true;
        }
        return bl5;
    }

    private final String getCurrentExamId() {
        return this.mReportViewer.getReportsPane().getCurrentExamId();
    }

    private final String getCurrentAccessionNumber() {
        return this.mReportViewer.getReportsPane().getCurrentAccessionNumber();
    }

    private final String defaultReportFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.mReportViewer.getPatient().getName().trim());
        if (!this.mIncludeAllReportsCheckBox.isSelected() || this.mReportViewer.getOrderMap().size() == 1) {
            stringBuffer.append(" - ");
            stringBuffer.append(string.trim());
        }
        stringBuffer.append(".pdf");
        return FileNaming.stripInvalidCharacters(stringBuffer.toString());
    }

    private final void showErrorMessage(String string) {
        MultiMonitorOptionDialog.showConfirmDialog(this, string, "Export Report", -1, 0);
    }

    private final /* synthetic */ void this() {
        this.mExportedReportFile = null;
    }

    public ReportExportDialog(Frame frame, ReportViewer reportViewer, ReportImageProvider reportImageProvider, ExportConfiguration exportConfiguration, File file) {
        super(frame, "Export PDF Report(s)", true);
        this.this();
        this.mReportImageProvider = reportImageProvider;
        this.mReportViewer = reportViewer;
        this.mExportConfiguration = exportConfiguration;
        this.init(frame, file);
    }

    private class ReportExportWorker
    implements Worker {
        File mFile;
        boolean mTemporaryPdf;

        public Object call() throws Exception {
            ReportExportDialog.this.createExporter().export(this.mFile);
            return null;
        }

        public void handleSuccess(Object object) {
            if (this.mTemporaryPdf) {
                ReportExportDialog.this.launchPdf(this.mFile);
            } else {
                ReportExportDialog.this.setExportedReportFile(this.mFile);
            }
        }

        public void handleCancel() {
            ReportExportDialog.this.dispose();
            this.mFile.delete();
        }

        public void handleException(Exception exception) {
            DebugManager.getDefault().printException("Exception on ReportExportWorker", exception);
            ReportExportDialog.this.showErrorMessage("Could not generate the PDF file.\nPlease contact your PACS administrator.");
        }

        public ReportExportWorker(File file, boolean bl) {
            this.mFile = file;
            this.mTemporaryPdf = bl;
        }
    }

    private class PdfFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".pdf");
        }

        public String getDescription() {
            return "Adobe PDF files";
        }

        private PdfFileFilter() {
        }
    }
}

