/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.HeaderRenderer;
import ReportViewerLibrary.Export.HtmlWorkerFixer;
import ReportViewerLibrary.Export.ReportImageProvider;
import ReportViewerLibrary.Util.OrderDateComparator;
import ReportViewerXml.Order;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Graphic;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReportExporter {
    private static final float ITEXT_IMAGE_DPI_RENDERING = 72.0f;
    public static final SimpleDateFormat PRINTED_ON_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final Font REPORT_SECTION_TITLE_FONT = FontFactory.getFont((String)"unknown", (float)14.0f, (int)5);
    private static Font DEFAULT_FONT = FontFactory.getFont((String)"unknown");
    private static final int FOOTER_FONT_SIZE = 10;
    private Patient mPatient;
    private Map mOrders;
    private Map mOrderHeaders;
    private ReportImageProvider mReportImageProvider;
    private Date mExportDate;
    private com.lowagie.text.Image mLogo;
    private BaseFont mFooterFont;
    private String mCurrentExamId;
    private boolean mIheMode;
    private boolean mPrintAll;
    private boolean mIncludeKeyImages;
    private boolean mIncludeImpressions;
    private boolean mIncludeHistory;
    private final ExportConfiguration mExportConfiguration;

    private final void initHeaderLogo() {
        try {
            this.mLogo = com.lowagie.text.Image.getInstance((URL)this.mReportImageProvider.getPrintableLogoUrl());
            if (this.mLogo != null) {
                this.scaleLogoAccordingToDPI();
            }
        }
        catch (Exception exception) {
            String string = "Could not retrive printable logo from URL: [" + this.mReportImageProvider.getPrintableLogoUrl() + "]. No logo will be included on exported reports.";
            DebugManager.getDefault().printError(string);
        }
    }

    private final void scaleLogoAccordingToDPI() {
        DebugManager.getDefault().printTrace("Logo resolution = " + this.mLogo.width() + " x " + this.mLogo.height());
        DebugManager.getDefault().printTrace("Logo DPI = " + this.mLogo.getDpiX() + " x " + this.mLogo.getDpiY());
        if ((float)this.mLogo.getDpiX() > 72.0f && (float)this.mLogo.getDpiY() > 72.0f) {
            float f = 72.0f / (float)this.mLogo.getDpiX() * 100.0f;
            float f2 = 72.0f / (float)this.mLogo.getDpiY() * 100.0f;
            DebugManager.getDefault().printTrace("Scaling logo by (" + f + "%, " + f2 + "%) to fit DPI");
            if (f > 0.0f && f2 > 0.0f) {
                this.mLogo.scalePercent(f, f2);
            }
        }
    }

    private final void initFooterFont() {
        try {
            this.mFooterFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception exception) {
            String string = "Could not initialize footer font. Reports will be exported with no footer!";
            DebugManager.getDefault().printException(string, exception);
        }
    }

    private final float inchesToPoints(float f) {
        return 72.0f * f;
    }

    public void setPrintAll(boolean bl) {
        this.mPrintAll = bl;
    }

    public void setIncludeKeyImages(boolean bl) {
        this.mIncludeKeyImages = bl;
    }

    public void setIncludeImpressions(boolean bl) {
        this.mIncludeImpressions = bl;
    }

    public void setIncludeHistory(boolean bl) {
        this.mIncludeHistory = bl;
    }

    public void export(File file) throws IOException, DocumentException {
        this.export(file, new Date());
    }

    public void export(File file, Date date) throws IOException, DocumentException {
        DebugManager.getDefault().printTrace("Exporting report to " + file.getAbsolutePath());
        this.mExportDate = date;
        Document document = new Document(PageSize.LETTER, this.inchesToPoints(this.mExportConfiguration.getLeftMargin()), this.inchesToPoints(this.mExportConfiguration.getRightMargin()), this.inchesToPoints(this.mExportConfiguration.getTopMargin()), this.inchesToPoints(this.mExportConfiguration.getBottomMargin()));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
        ReportPageHandler reportPageHandler = new ReportPageHandler();
        pdfWriter.setPageEvent((PdfPageEvent)reportPageHandler);
        Order order = (Order)this.mOrders.get(this.mCurrentExamId);
        reportPageHandler.setCurrentOrder(order);
        document.open();
        reportPageHandler.checkForException();
        this.addReport(document, order);
        if (this.mPrintAll) {
            ArrayList arrayList = new ArrayList(this.mOrders.values());
            Collections.sort(arrayList, new OrderDateComparator(this.mIheMode, false, this.mOrderHeaders));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Order order2 = (Order)iterator.next();
                if (order2 == order) continue;
                reportPageHandler.setCurrentOrder(order2);
                document.newPage();
                this.addReport(document, order2);
                reportPageHandler.checkForException();
            }
        }
        document.close();
    }

    private final void addReport(Document document, Order order) throws IOException, DocumentException {
        HTMLWorker hTMLWorker = new HTMLWorker((DocListener)document);
        this.addReportSectionTitle(document, "Report", false);
        String string = StringCheck.isStringBlank(order.getReport()) ? HtmlWorkerFixer.fixHtml("There is no report for this order.") : HtmlWorkerFixer.fixHtml(order.getReport());
        hTMLWorker.parse((Reader)new StringReader(string));
        if (this.mIncludeImpressions) {
            this.addReportSectionTitle(document, "Impressions", true);
            string = StringCheck.isStringBlank(order.getImpression()) ? HtmlWorkerFixer.fixHtml("There are no impressions for this order.") : HtmlWorkerFixer.fixHtml(order.getImpression());
            hTMLWorker.parse((Reader)new StringReader(string));
        }
        if (this.mIncludeHistory) {
            this.addReportSectionTitle(document, "Clinical History", true);
            string = StringCheck.isStringBlank(order.getHistory()) ? HtmlWorkerFixer.fixHtml("There is no clinical history for this order.") : HtmlWorkerFixer.fixHtml(order.getHistory());
            hTMLWorker.parse((Reader)new StringReader(string));
        }
        this.addKeyImages(document, order.getAccession());
    }

    private final void addReportSectionTitle(Document document, String string, boolean bl) throws DocumentException {
        if (bl) {
            document.add((Element)new Paragraph("\n", DEFAULT_FONT));
        }
        document.add((Element)new Paragraph(string, REPORT_SECTION_TITLE_FONT));
    }

    private final void addKeyImages(Document document, String string) throws IOException, DocumentException {
        int n = this.mReportImageProvider.getKeyImageCount(string);
        if (!this.mIncludeKeyImages || n == 0) {
            return;
        }
        document.newPage();
        int n2 = (int)Math.ceil(Math.sqrt(n));
        int n3 = (int)Math.ceil((double)n / (double)n2);
        float f = document.top() - 120.0f;
        float f2 = document.getPageSize().width() - 36.0f - (float)(n3 - 1) * 6.0f;
        float f3 = f - document.bottom() - (float)(n2 - 1) * 6.0f;
        float f4 = f2 / (float)n3;
        float f5 = f3 / (float)n2;
        int n4 = (int)(f4 / 72.0f * 300.0f);
        int n5 = (int)(f5 / 72.0f * 300.0f);
        Image image = this.mReportImageProvider.getKeyImage(string, 0, n4, n5);
        com.lowagie.text.Image image2 = com.lowagie.text.Image.getInstance((Image)image, null);
        image2.scaleToFit(f4, f5);
        float f6 = (f4 - image2.scaledWidth()) / 2.0f;
        float f7 = 18.0f;
        float f8 = f;
        int n6 = 0;
        while (n6 < n) {
            Image image3 = this.mReportImageProvider.getKeyImage(string, n6, n4, n5);
            com.lowagie.text.Image image4 = com.lowagie.text.Image.getInstance((Image)image3, null);
            image4.setAlignment(1);
            image4.scaleToFit(f4, f5);
            image4.setAbsolutePosition(f7 + f6, f8 - image4.scaledHeight());
            document.add((Element)image4);
            f7 += f4 + 6.0f;
            if (f7 > f2) {
                f7 = 18.0f;
                f8 -= image4.scaledHeight() + 6.0f;
            }
            ++n6;
        }
    }

    private final void addHeader(Document document, Order order) throws DocumentException {
        String string = this.mIheMode ? order.getPacsKey() : order.getAccession();
        OrderHeader orderHeader = (OrderHeader)this.mOrderHeaders.get(string);
        HeaderRenderer headerRenderer = new HeaderRenderer(this.mExportConfiguration);
        com.lowagie.text.Image image = this.mExportConfiguration.includeLogo() ? this.mLogo : null;
        document.add((Element)headerRenderer.getLogoAndTitle(image));
        document.add((Element)headerRenderer.getFields(orderHeader, this.mPatient));
        if (this.mExportConfiguration.includeLineSeparator()) {
            document.add(ReportExporter.createParagraph(5));
            document.add(ReportExporter.createHorizontalLine());
        }
        document.add(ReportExporter.createParagraph(8.0f));
    }

    private static final Element createParagraph(float f) {
        Paragraph paragraph = new Paragraph();
        paragraph.setSpacingAfter(f);
        return paragraph;
    }

    private static final Element createHorizontalLine() {
        Graphic graphic = new Graphic();
        graphic.setHorizontalLine(1.0f, 100.0f, Color.black);
        return graphic;
    }

    private final void addFooter(PdfWriter pdfWriter, Document document, Date date, PdfTemplate pdfTemplate, int n) {
        String string = "Report exported on " + PRINTED_ON_DATE_FORMAT.format(date) + " -- Page " + n + " of ";
        float f = this.mFooterFont.getWidthPoint(string, 10.0f);
        float f2 = (document.getPageSize().width() - f) / 2.0f;
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        float f3 = this.inchesToPoints(this.mExportConfiguration.getFooterMargin());
        pdfContentByte.beginText();
        pdfContentByte.setFontAndSize(this.mFooterFont, 10.0f);
        pdfContentByte.setTextMatrix(f2, f3);
        pdfContentByte.showText(string);
        pdfContentByte.endText();
        pdfContentByte.addTemplate(pdfTemplate, f2 + f, f3);
    }

    private final /* synthetic */ void this() {
        this.mLogo = null;
        this.mFooterFont = null;
        this.mPrintAll = true;
        this.mIncludeKeyImages = true;
        this.mIncludeImpressions = true;
        this.mIncludeHistory = true;
    }

    public ReportExporter(Patient patient, Map map, Map map2, ReportImageProvider reportImageProvider, String string, boolean bl, ExportConfiguration exportConfiguration) {
        this.this();
        this.mPatient = patient;
        this.mOrders = map;
        this.mOrderHeaders = map2;
        this.mCurrentExamId = string;
        this.mReportImageProvider = reportImageProvider;
        this.mIheMode = bl;
        this.mExportConfiguration = exportConfiguration;
        this.initHeaderLogo();
        this.initFooterFont();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ReportPageHandler
    extends PdfPageEventHelper {
        private Order mCurrentOrder;
        private int mCurrentOrderPageNumber;
        private PdfTemplate mReportPageTotalTemplate;
        private DocumentException mDocumentException;

        public void setCurrentOrder(Order order) {
            this.completeReportPageTotalTemplate(this.mCurrentOrderPageNumber - 1);
            this.mCurrentOrder = order;
        }

        public void onStartPage(PdfWriter pdfWriter, Document document) {
            try {
                if (this.shouldAddHeader(pdfWriter)) {
                    ReportExporter.this.addHeader(document, this.mCurrentOrder);
                }
                if (this.mReportPageTotalTemplate == null) {
                    this.mReportPageTotalTemplate = pdfWriter.getDirectContent().createTemplate(50.0f, 50.0f);
                }
                ReportExporter.this.addFooter(pdfWriter, document, ReportExporter.this.mExportDate, this.mReportPageTotalTemplate, this.mCurrentOrderPageNumber++);
            }
            catch (DocumentException documentException) {
                this.mDocumentException = documentException;
            }
        }

        private final boolean shouldAddHeader(PdfWriter pdfWriter) {
            if (!ReportExporter.this.mExportConfiguration.includeHeader()) {
                return false;
            }
            if (pdfWriter.getPageNumber() == 1) {
                return true;
            }
            return ReportExporter.this.mExportConfiguration.repeatHeader();
        }

        public void onCloseDocument(PdfWriter pdfWriter, Document document) {
            this.completeReportPageTotalTemplate(this.mCurrentOrderPageNumber - 2);
        }

        private final void completeReportPageTotalTemplate(int n) {
            if (this.mReportPageTotalTemplate == null || ReportExporter.this.mFooterFont == null) {
                return;
            }
            this.mReportPageTotalTemplate.beginText();
            this.mReportPageTotalTemplate.setFontAndSize(ReportExporter.this.mFooterFont, 10.0f);
            this.mReportPageTotalTemplate.showText(String.valueOf(n));
            this.mReportPageTotalTemplate.endText();
            this.mReportPageTotalTemplate = null;
            this.mCurrentOrderPageNumber = 1;
        }

        public void checkForException() throws DocumentException {
            if (this.mDocumentException != null) {
                throw this.mDocumentException;
            }
        }

        private final /* synthetic */ void this() {
            this.mCurrentOrder = null;
            this.mCurrentOrderPageNumber = 1;
            this.mReportPageTotalTemplate = null;
            this.mDocumentException = null;
        }

        private ReportPageHandler() {
            this.this();
        }
    }
}

