/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import GuiUtilities.Util.GuiUtilities;
import ReportViewerLibrary.Gui.ImpressionsTool;
import ReportViewerLibrary.Gui.ReportViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class ActionHandler
implements ActionListener {
    public void actionPerformed(ActionEvent actionEvent) {
        ReportViewer reportViewer = this.getReportViewer();
        if ("CLOSE".equals(actionEvent.getActionCommand())) {
            this.close();
        } else if ("EXPORT".equals(actionEvent.getActionCommand())) {
            reportViewer.showExportDialog();
        } else if ("ALWAYS_ON_TOP".equals(actionEvent.getActionCommand())) {
            reportViewer.setAlwaysOnTop(reportViewer.isAlwaysOnTopChecked());
        } else if ("CHANGE_VIEW".equals(actionEvent.getActionCommand())) {
            reportViewer.changeView();
        } else if ("ADD_IMPRESSION".equals(actionEvent.getActionCommand())) {
            this.showImpressionDialog();
        }
    }

    private final void showImpressionDialog() {
        ReportViewer reportViewer = this.getReportViewer();
        ImpressionsTool impressionsTool = reportViewer.createImpressionsTool();
        GuiUtilities.centerWindowOnParent(reportViewer.getOwner(), impressionsTool);
        impressionsTool.show();
    }

    protected abstract ReportViewer getReportViewer();

    protected abstract void close();
}

