/*
 * Decompiled with CFR 0.152.
 */
package RuntimeTool;

import DataStructures.Pair;
import FileUtilities.FileNaming;
import FileUtilities.FileOperations;
import StringUtilities.PrintfFormat;
import StringUtilities.StringSplit;
import StringUtilities.ToString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gnu.posix.PFile;
import org.gnu.posix.StatInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    private static final SimpleDateFormat mDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final long mCRITICAL_SIZE = 1596700000L;
    private static final String mErrorSeparator = "*************************";
    private static final PrintfFormat mSecondsTrimmedFormat = new PrintfFormat("%.3f");
    private static boolean mHaveJPosix = true;
    private Set mDebugHash;
    private Set mExceptions;
    private String mHostName;
    private String mComponentName;
    private String mFilename;
    private PrintWriter mPrintWriter;
    private boolean mIsRegularFile;
    private long mCriticalSizeInBytes;
    private boolean mMoveCurrentExistingFile;
    private Map mTimers;
    private Date mProfileTimestamp;
    private StatInfo mOldStat;

    public Debug getIdentifiedDebug(String string) {
        Debug debug = new Debug(this);
        debug.setComponentName(this.mComponentName + ':' + string);
        if ("stdout".equals(this.mFilename)) {
            throw new IllegalStateException("cannot create identified Debug object for stdout");
        }
        if (string.matches(".*?[\\/\\\\:].*")) {
            throw new IllegalArgumentException("bad identifier (contains path characters): " + string);
        }
        File file = new File(this.mFilename);
        Pair pair = FileNaming.splitExtension(file);
        String string2 = pair.getFirst() + '_' + string + pair.getSecond();
        debug.setFilename(new File(file.getParent(), string2).getPath());
        return debug;
    }

    public String toString() {
        return super.toString() + ": " + (this.mIsRegularFile ? this.mFilename : "(stdout)");
    }

    public synchronized void close() {
        if (this.mIsRegularFile && this.mPrintWriter != null) {
            this.mPrintWriter.close();
        }
    }

    protected void finalize() {
        this.close();
    }

    public PrintWriter getFile() {
        return this.mPrintWriter;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public void startTimer(String string, String string2) {
        this.mTimers.put(string, new Date());
        string2 = string2 == null ? "--> Start (timer " + string + ')' : "--> Start: " + string2 + " (timer " + string + ')';
        this.print("PROFILE", string2);
    }

    public void startTimer(String string) {
        this.startTimer(string, null);
    }

    public boolean printElapsedTime(String string, String string2) {
        if (!this.isKeyAccepted("PROFILE")) {
            return true;
        }
        long l = this.getElapsedTime(string);
        return this.print("PROFILE", "<-- Elapsed: " + (double)l / 1000.0 + " sec: " + string2 + " (timer " + string + ')');
    }

    public long getElapsedTime(String string) {
        long l = System.currentTimeMillis() - ((Date)this.mTimers.get(string)).getTime();
        return l;
    }

    public void setProfile(String string) {
        if (!this.isKeyAccepted("PROFILE")) {
            return;
        }
        this.mProfileTimestamp = new Date();
        this.print("PROFILE", "Setting profile: " + string);
    }

    public void printProfile(String string) {
        if (!this.isKeyAccepted("PROFILE")) {
            return;
        }
        double d = (double)(System.currentTimeMillis() - this.mProfileTimestamp.getTime()) / 1000.0;
        String string2 = mSecondsTrimmedFormat.sprintf(d);
        this.print("PROFILE", "Elapsed time [" + string2 + "] seconds: " + string);
    }

    public void setAppendToFile(boolean bl) {
        this.setMoveCurrentExistingFile(bl ^ true);
    }

    public boolean initialize(String string, String string2, String[] stringArray, long l) {
        this.mComponentName = string;
        if (this.mMoveCurrentExistingFile) {
            this.moveCurrentExistingFile(string2);
        }
        this.setAllKeys(stringArray);
        return this.setFilename(string2);
    }

    public boolean initialize(String string, String string2, String string3) {
        return this.initialize(string, string2, Debug.splitKeys(string3));
    }

    public boolean initialize(String string, String string2, String[] stringArray) {
        return this.initialize(string, string2, stringArray, 0L);
    }

    public boolean initialize(String string, String string2) {
        return this.initialize(string, string2, new String[0], 0L);
    }

    public void setMoveCurrentExistingFile(boolean bl) {
        this.mMoveCurrentExistingFile = bl;
    }

    public void setCriticalFileSizeInBytes(long l) {
        this.mCriticalSizeInBytes = l;
    }

    public synchronized void setComponentName(String string) {
        this.mComponentName = string;
    }

    public synchronized String getComponentName() {
        if (this.mComponentName != null) {
            return this.mComponentName;
        }
        return "";
    }

    public synchronized void printMap() {
        Iterator iterator = this.mDebugHash.iterator();
        while (iterator.hasNext()) {
            this.println("Got key: " + iterator.next());
        }
    }

    public synchronized void turnOff() {
        this.mDebugHash.clear();
    }

    public void resetKeys(String string) {
        this.resetKeys(Debug.splitKeys(string));
    }

    synchronized void resetKeys(String[] stringArray) {
        this.mDebugHash.clear();
        this.setAllKeys(stringArray);
    }

    public synchronized boolean isKeyAccepted(String string) {
        if (string.equals("ALWAYS") || this.mDebugHash.contains("ALL")) {
            if (this.mExceptions.isEmpty()) {
                return true;
            }
            return this.mExceptions.contains(string) ^ true;
        }
        return this.mDebugHash.contains(string);
    }

    public synchronized String getAcceptedKeys() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.mDebugHash.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("|");
        }
        Iterator iterator2 = this.mExceptions.iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append("|-").append((String)iterator2.next());
            if (!iterator2.hasNext()) continue;
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    public boolean print(String string, String string2) {
        if (this.isKeyAccepted(string)) {
            return this.printMessage(string, string2, false);
        }
        return true;
    }

    public boolean printAlways(String string) {
        return this.printMessage("ALWAYS", string, false);
    }

    public boolean printError(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append("\n").append(mErrorSeparator).append("\nERROR: ").append(string).append("\n").append(mErrorSeparator);
        return this.printMessage("ALWAYS", stringBuffer.toString(), false);
    }

    public synchronized void printException(String string, Throwable throwable) {
        this.printError(string);
        this.printStackTrace(throwable);
    }

    public boolean printTrace(String string) {
        return this.print("TRACE", string);
    }

    public boolean printWarning(String string) {
        return this.print("WARNING", string);
    }

    public boolean printDebug(String string) {
        return this.print("DEBUG", string);
    }

    public boolean printDebug(String string, String string2) {
        return this.print("DEBUG:" + string, string2);
    }

    public boolean printBinary(String string, String string2) {
        if (this.isKeyAccepted(string)) {
            return this.printMessage(string, string2, true);
        }
        return true;
    }

    public boolean printStackTrace() {
        return this.printStackTrace(new Exception());
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "NULL exception passed to getStackTrace";
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            String string = stringWriter.toString();
            printWriter.close();
            stringWriter.close();
            return string;
        }
        catch (IOException iOException) {
            return "IOException while trying to get stack trace";
        }
    }

    public boolean printStackTrace(Throwable throwable) {
        return this.printAlways("Stack trace:\n" + Debug.getStackTrace(throwable));
    }

    public boolean printHash(String string, Hashtable hashtable) {
        return this.print(string, ToString.hashtable(hashtable));
    }

    public boolean setFilename(String string) {
        this.mFilename = string;
        if (string.equals("stdout")) {
            return this.openStdout();
        }
        return this.openRegularFile();
    }

    private final boolean openRegularFile() {
        try {
            if (!FileOperations.createDirectory(FileNaming.dirName(this.mFilename))) {
                throw new IOException("Unable to create directory");
            }
            this.close();
            this.mPrintWriter = new PrintWriter((Writer)new FileWriter(this.mFilename, true), true);
            this.mOldStat = Debug.statFile(this.mFilename);
            this.mIsRegularFile = true;
            return true;
        }
        catch (IOException iOException) {
            String string = this.mFilename;
            this.mFilename = "stdout";
            this.openStdout();
            this.println("Error opening log file '" + string + "': " + iOException);
            return false;
        }
    }

    private final boolean openStdout() {
        this.openStdout(System.out);
        return true;
    }

    void openStdout(PrintStream printStream) {
        this.mIsRegularFile = false;
        this.mPrintWriter = new PrintWriter(printStream, true);
        this.mOldStat = null;
    }

    private final void moveCurrentExistingFile(String string) {
        if (string.equals("stdout")) {
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            file.renameTo(new File(this.getNewFilename(string, false)));
        }
    }

    public synchronized void moveExistingFile(boolean bl) {
        if (this.mFilename == null || this.mFilename.equals("")) {
            throw new IllegalStateException("Filename for this debug object has not been set");
        }
        if (this.mFilename.equals("stdout")) {
            return;
        }
        File file = new File(this.mFilename);
        if (file.exists() && file.length() > 0L) {
            this.close();
            file.renameTo(new File(this.getNewFilename(this.mFilename, bl)));
            this.openRegularFile();
        }
    }

    public synchronized void moveExistingFile() {
        this.moveExistingFile(false);
    }

    private final String getNewFilename(String string, boolean bl) {
        Object object;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        String string2 = string;
        if (bl) {
            object = new File(new File(string).getParentFile(), (String)FileNaming.splitExtension(new File(string)).getFirst());
            string2 = ((File)object).getAbsolutePath();
        }
        object = "." + simpleDateFormat.format(date) + ".log";
        return string2 + (String)object;
    }

    private final synchronized boolean printMessage(String string, String string2, boolean bl) {
        if (this.mPrintWriter == null) {
            return false;
        }
        if (this.mIsRegularFile && !this.checkFile()) {
            return false;
        }
        if (bl) {
            string2 = this.getHexMessage(string2);
        }
        return this.println(this.getHeader(string) + string2);
    }

    private final boolean println(String string) {
        this.mPrintWriter.println(string);
        return this.mPrintWriter.checkError() ^ true;
    }

    private final boolean checkFile() {
        StatInfo statInfo = Debug.statFile(this.mFilename);
        StatInfo statInfo2 = this.mOldStat;
        boolean bl = statInfo == null ? true : statInfo2 != null && (statInfo.dev != statInfo2.dev || statInfo.ino != statInfo2.ino);
        this.mOldStat = statInfo;
        if (bl) {
            return this.openRegularFile();
        }
        return !this.criticalSizeReached(statInfo.size);
    }

    protected String getHexMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(2 * string.length() + string.length());
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(Integer.toHexString(string.charAt(n))).append(".");
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String getHeader(String string) {
        String string2 = mDateFormatter.format(new Date());
        String string3 = "[" + string2 + ' ' + this.mComponentName + ' ' + this.mHostName;
        if (!string.equals("ALWAYS")) {
            string3 = string3 + " (" + string + ')';
        }
        string3 = string3 + "] ";
        return string3;
    }

    private final boolean criticalSizeReached(long l) {
        boolean bl = false;
        if (l > this.mCriticalSizeInBytes) {
            bl = true;
        }
        return bl;
    }

    private final synchronized void setAllKeys(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-') {
                this.mExceptions.add(stringArray[n].substring(1));
            } else {
                this.mDebugHash.add(stringArray[n]);
            }
            ++n;
        }
    }

    private static final String[] splitKeys(String string) {
        List list = StringSplit.split(string, "|", true, true);
        return list.toArray(new String[list.size()]);
    }

    public static void testDeb() {
        Debug debug = new Debug("MY_COMPONENT", "DebugOutput.out", "FILE|DEBUG|TCPIP");
        System.out.println("Debug initialized to FILE DEBUG and TCPIP");
        try {
            debug.print("FILE", "1234567890");
            System.out.println("Press any key to continue");
            System.in.read();
            debug.print("FILE", "2234567890");
            System.out.println("Press any key to continue");
            System.in.read();
            debug.print("FILE", "3234567890");
            System.out.println("Press any key to continue");
            System.in.read();
            debug.print("FILE", "4234567890");
            System.out.println("Press any key to continue");
            System.in.read();
            debug.print("FILE", "5234567890");
            System.out.println("Press any key to continue");
            System.in.read();
            debug.print("FILE", "6234567890");
            System.out.println("Press any key to continue");
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void testNonInitializedObject() {
        Debug debug = new Debug();
        debug.printAlways("Shouldn't show up");
        try {
            System.out.println("After pressing enter there shouldn't be another DebugOutput.out.YYYYMM... file");
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void testAlwaysOneFile() {
        Debug debug = new Debug("SIMPLE2", "Output2.log", "");
        debug.resetKeys("yes");
        debug.printAlways("This goes to Output2.log");
        debug.print("yes", "This as well....");
        Debug debug2 = new Debug("SIMPLE", "Output.log", "");
        debug2.resetKeys(debug.getAcceptedKeys());
        debug2.printAlways("Hello there");
        debug2.print("yes", "this should print on Output.log");
        debug2.print("trace", "should not print");
        debug2.printAlways("1111 Hello again");
        debug2.printAlways("2222 Hello again");
        debug2.printAlways("3333Hello again");
    }

    public static void testCreateDirectory() {
        Debug debug = new Debug("DIR", "output/another/output.log", "");
        debug.printAlways("Hello there - directory should have been created.");
    }

    public static void testBinary() {
        System.err.println("Testing binary mode.");
        Debug debug = new Debug("BIN1", "stdout", "");
        debug.print("ALWAYS", "This is regular text debug.");
        debug.printBinary("ALWAYS", "Binary mode.");
        System.err.println("Now going to file file.log");
        Debug debug2 = new Debug("BIN2", "file.log", "");
        debug2.print("ALWAYS", "This is regular text to a file.");
        debug2.printBinary("ALWAYS", "Binary mode to a file");
    }

    private static final void testExceptions() {
        System.err.println("Testing exceptions...");
        Debug debug = new Debug("EXCEPTIONS", "stdout", "ALL|-TRACE|-DETAILED");
        debug.print("ALWAYS", "This gets printed since using ALWAYS");
        debug.printError("This gets printed in error mode");
        debug.print("YES", "It should be printed since we're using YES");
        debug.print("TRACE", "Should not be printed since using exception TRACE");
        debug.print("DETAILED", "Should not be printed since using exception DETAILED");
        debug.print("YES", "Previous printed line should be the YES one.");
    }

    private static final StatInfo statFile(String string) {
        if (!mHaveJPosix) {
            return null;
        }
        try {
            return PFile.stat((String)string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            mHaveJPosix = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            mHaveJPosix = false;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Debug.testBinary();
        Debug.testDeb();
        Debug.testNonInitializedObject();
        Debug.testAlwaysOneFile();
        Debug.testCreateDirectory();
        Debug.testExceptions();
    }

    private final /* synthetic */ void this() {
        this.mDebugHash = new HashSet();
        this.mExceptions = new HashSet();
        this.mFilename = "";
        this.mMoveCurrentExistingFile = true;
        this.mTimers = new HashMap();
        this.mProfileTimestamp = null;
    }

    public Debug() {
        this.this();
        this.mCriticalSizeInBytes = 1596700000L;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.mHostName = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.mHostName = "N/A";
        }
    }

    public Debug(String string, String string2, String string3) {
        this();
        this.mMoveCurrentExistingFile = false;
        this.initialize(string, string2, string3);
    }

    private Debug(Debug debug) {
        this.this();
        this.mDebugHash = new HashSet(debug.mDebugHash);
        this.mExceptions = new HashSet(debug.mExceptions);
        this.mHostName = debug.mHostName;
        this.mComponentName = debug.mComponentName;
        this.mCriticalSizeInBytes = debug.mCriticalSizeInBytes;
        this.mMoveCurrentExistingFile = debug.mMoveCurrentExistingFile;
    }
}

