/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.generated.impl.runtime;

import XmlSchema.generated.impl.runtime.MSVValidator;
import XmlSchema.generated.impl.runtime.NamespaceContextImpl;
import XmlSchema.generated.impl.runtime.Util;
import XmlSchema.generated.impl.runtime.ValidatableObject;
import XmlSchema.generated.impl.runtime.XMLSerializable;
import com.sun.xml.bind.ProxyGroup;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.validator.Messages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class ValidationContext {
    private final HashSet validatedObjects;
    private final NamespaceContextImpl nsContext;
    private final boolean validateID;
    private final HashSet IDs;
    private final HashMap IDREFs;
    private final ValidationEventHandler eventHandler;

    public void validate(ValidatableObject validatableObject) throws SAXException {
        if (this.validatedObjects.add(ProxyGroup.unwrap((Object)validatableObject))) {
            MSVValidator.validate(this, validatableObject);
        } else {
            this.reportEvent(validatableObject, Messages.format((String)"ValidationContext.CycleDetected"));
        }
    }

    public NamespaceContextImpl getNamespaceContext() {
        return this.nsContext;
    }

    public String onID(XMLSerializable xMLSerializable, String string) throws SAXException {
        if (!this.validateID) {
            return string;
        }
        if (!this.IDs.add(string)) {
            this.reportEvent(Util.toValidatableObject(xMLSerializable), Messages.format((String)"ValidationContext.DuplicateId", (Object)string));
        }
        return string;
    }

    public String onIDREF(XMLSerializable xMLSerializable, String string) throws SAXException {
        if (!this.validateID) {
            return string;
        }
        if (this.IDs.contains(string)) {
            return string;
        }
        this.IDREFs.put(string, xMLSerializable);
        return string;
    }

    protected void reconcileIDs() throws SAXException {
        if (!this.validateID) {
            return;
        }
        Iterator iterator = this.IDREFs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.IDs.contains(entry.getKey())) continue;
            ValidatableObject validatableObject = (ValidatableObject)entry.getValue();
            this.reportEvent(validatableObject, (ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format((String)"ValidationContext.IdNotFound", entry.getKey()), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)validatableObject)));
        }
        this.IDREFs.clear();
    }

    public void reportEvent(ValidatableObject validatableObject, String string) throws AbortSerializationException {
        this.reportEvent(validatableObject, (ValidationEvent)new ValidationEventImpl(1, string, (ValidationEventLocator)new ValidationEventLocatorImpl((Object)validatableObject)));
    }

    public void reportEvent(ValidatableObject validatableObject, Exception exception) throws AbortSerializationException {
        this.reportEvent(validatableObject, (ValidationEvent)new ValidationEventImpl(1, exception.toString(), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)validatableObject), (Throwable)exception));
    }

    public void reportEvent(ValidatableObject validatableObject, ValidationEvent validationEvent) throws AbortSerializationException {
        boolean bl;
        try {
            bl = this.eventHandler.handleEvent(validationEvent);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        if (!bl) {
            throw new AbortSerializationException(validationEvent.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.validatedObjects = new HashSet();
        this.nsContext = new NamespaceContextImpl(null);
        this.IDs = new HashSet();
        this.IDREFs = new HashMap();
    }

    ValidationContext(ValidationEventHandler validationEventHandler, boolean bl) {
        this.this();
        this.eventHandler = validationEventHandler;
        this.validateID = bl;
    }
}

