/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.process;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import StringUtilities.ToString;
import com.intelerad.lib.process.CommandLauncher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;

public class UrlLauncher {
    private static final String URL_FILE_SUFFIX = ".url";
    private URL mUrl;
    private Debug mDebug;
    private boolean mDeleteOldTempFiles;
    private String mTempFilePrefix;

    public Process launch() throws IOException {
        if ("Linux".equals(System.getProperty("os.name"))) {
            return this.linuxLaunch();
        }
        File file = this.createUrlFile(this.mUrl.toExternalForm());
        Process process = this.launchUrlFile(file);
        new Thread(new FileRemover(process, file)).start();
        return process;
    }

    private final Process linuxLaunch() throws IOException {
        CommandLauncher commandLauncher = new CommandLauncher("Linux Browser", "htmlview");
        commandLauncher.appendParameter(this.mUrl.toExternalForm());
        return commandLauncher.launch();
    }

    private final Process launchUrlFile(File file) throws IOException {
        CommandLauncher commandLauncher = new CommandLauncher("rundll32.exe", "rundll32.exe");
        commandLauncher.appendParameter("shdocvw.dll,OpenURL");
        commandLauncher.appendParameter(file.getAbsolutePath());
        return commandLauncher.launch();
    }

    private final File createUrlFile(String string) throws IOException {
        File file = File.createTempFile(this.mTempFilePrefix, URL_FILE_SUFFIX);
        file.deleteOnExit();
        String string2 = "[InternetShortcut]\nURL=" + string;
        this.mDebug.printTrace("Creating temporary URL file: '" + file.getAbsolutePath() + "',contents: [" + string2 + ']');
        if (this.mDeleteOldTempFiles) {
            this.deleteTempUrlFiles(file);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
        bufferedWriter.write(string2);
        bufferedWriter.close();
        return file;
    }

    private final void deleteTempUrlFiles(File file) {
        File file2 = file.getParentFile();
        this.mDebug.printTrace("Finding and deleting temp URL files in " + file2.getAbsolutePath() + " except for " + file.getName());
        Object[] objectArray = file2.listFiles(new FilenameFilter(this, file){
            final /* synthetic */ UrlLauncher this$0;
            final /* synthetic */ File val$urlFile;

            public final boolean accept(File file, String string) {
                boolean bl = false;
                if (!string.equals(this.val$urlFile.getName()) && string.startsWith(UrlLauncher.access$0(this.this$0)) && string.endsWith(".url")) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = urlLauncher;
                this.val$urlFile = file;
            }
        });
        this.mDebug.printTrace("Temp URL files to delete: " + ToString.array(objectArray));
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.mDebug.printTrace("Deleting temp URL file " + ((File)object).getName());
            ((File)object).delete();
            ++n;
        }
    }

    static /* synthetic */ String access$0(UrlLauncher urlLauncher) {
        return urlLauncher.mTempFilePrefix;
    }

    public UrlLauncher(URL uRL, String string, boolean bl) {
        this.mUrl = uRL;
        this.mTempFilePrefix = string;
        this.mDeleteOldTempFiles = bl;
        this.mDebug = DebugManager.getDefault();
    }

    private static class FileRemover
    implements Runnable {
        private final Process mProcess;
        private final File mFile;

        public void run() {
            while (true) {
                try {
                    this.mProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.mFile.delete();
        }

        public FileRemover(Process process, File file) {
            this.mProcess = process;
            this.mFile = file;
        }
    }
}

